<?php get_header(); ?>

	<div id="primary" class="site-content">
		<div id="content" role="main">

			<?php 

			while ( have_posts() ) : the_post(); 

				// Show item details?
				$show_details = get_post_meta($post->ID, 'theme_portfolio_show_details', true);

				// Title position
				$title_position = get_post_meta($post->ID, 'theme_portfolio_title', true);
				$title_position = ($title_position == 'above') ? 'above' : 'below';
				?>

				<?php if ($title_position == 'above') { ?>
					<nav class="nav-single-portfolio">
						<span class="post-nav post-next"><?php theme_next_portfolio_item('<i class="fa fa-angle-right nav-arrow"></i>'); ?></span>
						<span class="post-nav post-prev"><?php theme_prev_portfolio_item( '<i class="fa fa-angle-left nav-arrow"></i>'); ?></span>
					</nav><!-- .nav-single -->
					<?php 

					// Title (above featured image)
					theme_post_title();

				} ?>

				<header class="post-header <?php echo 'title_'.$title_position; ?>">
					<?php 

					// Post formats that use the featured image (standard, image, audio)
					//................................................................
					$no_thumbnail = array('gallery', 'video');
					$media = get_the_post_thumbnail($post->ID, 'full-thumb');
					if ( $media && !in_array(get_post_format(), $no_thumbnail) ) : 
						?>
						<div class="featured-image">
							<div class="styled-image <?php echo get_post_format() ?>">
								<?php echo $media ?>
								<div class="inner-overlay"></div>
							</div>
						</div>
						<?php 
					endif;

					// Media selected by post format
					switch( get_post_format() ) {

						case "audio" :
							// Audio Player
							theme_audio_player($post->ID);
							break;
						case "gallery" :
							// Gallery slide show (rotator)
							$size  = get_post_image_size( 'full-thumb' );
							// Check for specific width and height settings
							$max_w = '';
							$max_h = '';
							$style = '';
							if (is_array($size)) {
								if ($size[0] != 0) $max_w = 'max-width: '.$size[0].'px;';
								if ($size[1] != 0) $max_h = 'max-height: '.$size[0].'px;';
								$style = 'style="'.$max_w.' '.$max_h.'"';
								$size = $size[0].'x'.$size[1];
							}
							$rotatorParams = array(
								'columns'      => 1, 
								'type'         => 'post-gallery',
								'image_size'   => $size,
								'transition'   => 'fade', 
								'slide_paging' => 'true', 
								'autoplay'     => 'true',
								'interval'     => '3500',
								'class'        => 'slideshow'
							);
							?>
							<div class="featured-image" <?php echo $style ?>>
								<div class="styled-image <?php echo get_post_format() ?>"><?php echo theme_content_rotator( $rotatorParams ); ?></div>
							</div>
							<?php
							break;
						case "video" :
							// Video Player or Embed
							theme_video_player($post->ID);
							break;
					} ?>

				</header>

				<?php if ($title_position == 'below') { ?>
					<nav class="nav-single-portfolio">
						<span class="post-nav post-next"><?php theme_next_portfolio_item('<i class="fa fa-angle-right nav-arrow"></i>'); ?></span>
						<span class="post-nav post-prev"><?php theme_prev_portfolio_item( '<i class="fa fa-angle-left nav-arrow"></i>'); ?></span>
					</nav><!-- .nav-single -->
					<?php 

					// Title (below featured image)
					theme_post_title();

				} ?>
				<div class="row-fluid">
					<div class="<?php echo ($show_details == 'hide') ? 'span12' : 'span8'; ?>">

						<div class="entry-content">
							<?php the_content(); ?>
						</div><!-- .entry-content -->

					</div>
					<?php if ($show_details !== 'hide') : ?>
					<div class="span4">
						<div class="entry-meta portfolio-details">
							<?php 
								// Portfolio meta details
								if( $item_client = get_post_meta($post->ID, 'theme_portfolio_client', true) ) {
									echo '<h5>' . __('Client', 'framework') .'</h5><p>'. $item_client .'</p>';
								}
								if( $item_date = get_post_meta($post->ID, 'theme_portfolio_date', true) ) {
									echo '<h5>' . __('Date', 'framework') .'</h5><p>'. $item_date .'</p>';
								}
								if( $item_details = get_post_meta($post->ID, 'theme_portfolio_details', true) ) {
									echo '<div>'. stripslashes(htmlspecialchars_decode($item_details)) .'</div>';
								}
								if( $item_url = get_post_meta($post->ID, 'theme_portfolio_url', true) ) {
									echo '<h5 class="project-link"><a href="'. $item_url .'">'. __('View Project', 'framework') .' <i class="fa fa-angle-right"></i></a></h5><br>';
								}
							?>
						</div>
					</div>
					<?php endif; // ($show_details !== 'hide') ?>

					<footer class="entry-footer entry-meta">
						<span class="entry-portfolio-category"><?php the_terms($post->ID, 'portfolio-category', '', ', ', ''); ?></span>
					</footer><!-- .entry-meta -->

				</div>

				<?php 
			endwhile; // end of the loop. 

			edit_post_link( __( 'Edit', 'framework' ), '<span class="edit-link">', '</span>' ); ?>

		</div><!-- #content -->
	</div><!-- #primary -->

<?php get_footer(); ?>